#MTMM syntax  Mplus R
#last updated 03-11-2017
# built with R 3.3.0
# packages all with version at the date above
# questions: p.lugtig@uu.nl

rm(list=ls(all=TRUE))
#setwd("C:/Users/plugtig/dropbox/Peter/common metric/")
setwd("D:/SURFdrive/Onderzoek/common metric/")
#install R to mplus
#install.packages("MplusAutomation")
library("MplusAutomation")


##############################################################################################
######################### VARIABLES USED #######################################################
##################################################################################################

#X1 = mean(au09a036,au09a233) . Het Nederlands parlement?   0 = helemaal geen vertrouwen 10 = volledig vertrouwen
#X2 = mean(au09a037,au09a234) . Het rechtsstelsel?          0 = helemaal geen vertrouwen 10 = volledig vertrouwen
#X3 = mean(au09a038,au09a235) . De politie?                 0 = helemaal geen vertrouwen 10 = volledig vertrouwen
#X4 = mean(au09a039,au09a236) . Het Nederlands parlement?   0 = helemaal geen vertrouwen 5 = volledig vertrouwen (*2)
#X5 = mean(au09a040,au09a237) . Het rechtsstelsel?          0 = helemaal geen vertrouwen 5 = volledig vertrouwen (*2)
#X6 = mean(au09a041,au09a238) . De politie?                 0 = helemaal geen vertrouwen 5 = volledig vertrouwen (*2)
#X7 = mean(au09a042,au09a239) . Het Nederlands parlement?   UITGEBREIDERE UITLEG SCHAAL - 0, 10 ERTUSSENIN    
#X8 = mean(au09a044,au09a241) . Het rechtsstelsel?          UITGEBREIDERE UITLEG SCHAAL - 0, 10 ERTUSSENIN  
#X9 = mean(au09a046,au09a243) . De politie?                 UITGEBREIDERE UITLEG SCHAAL - 0, 10 ERTUSSENIN  

###################################################################################################


# create input files from template

#1. CTCM-1 models
#createModels("C:/Users/plugtig/Dropbox/Peter/common metric/template MTMM social trust.txt")
#createModels("C:/Users/Lugti101/SURFdrive/Onderzoek/common metric/template MTMM social trust ctcm-1.txt")
# 2. meref models
createModels("D:/SURFdrive/Onderzoek/common metric/template MTMM social trust meref.txt")


#run batches of mplus models
#runModels("C:/Users/plugtig/Dropbox/Peter/common metric/social trust", recursive=T,showOutput=T)
#runModels("C:/Users/Lugti101/SURFdrive/Onderzoek/common metric/social trust", recursive=T,showOutput=T)
#runModels("/Users/peter/Dropbox/Peter/common metric/social trust", recursive=T,showOutput=T)
runModels("D://SURFdrive/Onderzoek/common metric/social trust meref", recursive=T,showOutput=T)


#extract relevant output from Batch job
#install.packages("devtools")
#require(devtools)
#install_github("MplusAutomation", "michaelhallquist")
#alloutput <- readModels("C:/Users/plugtig/Dropbox/Peter/common metric/social trust", recursive = T)
#alloutput <- readModels("C:/Users/Lugti101/SURFdrive/Onderzoek/common metric/social trust", recursive = T)
alloutput <- readModels("D:/SURFdrive/Onderzoek/common metric/social trust meref", recursive = T)
# ignore the warnings

# alternative
fit <- extractModelSummaries("D:/SURFdrive/Onderzoek/common metric/social trust meref", recursive=T)
results <- extractModelParameters("D:/SURFdrive/Onderzoek/common metric/social trust meref", recursive=T)

# now view fit and manually deselct all models with convergence problems
# problem remains only for 200912. Here model does not converge. 
# here, I manually remove the model contraints, and run the model again. It is 
# a bit odd that the model constraints cause problems, but the problem is that the variances here are close 
# to the boundary estimates of 0. Removing these constraint helps, and shows that estimates
# of the variances are indeed close to 0.

View(fit)
# create a table with model fit indices 
# add a column with sample size
# this is not given, but can be calculated using rsmea-formula (which includes n)
# failed: rmsea <- ((fit[,7]-fit[,8])^(0.5))/fit[,20]
# failed: nperwave <- rmsea^(2)/fit[,8]
# however, then I get the total n (of course). I need to do something different with the actual data.
library(foreign)
ndata <- read.spss('D:/SURFdrive/Onderzoek/common metric/social trust.sav', reencode=-999)
ndata <- as.data.frame(ndata)
correlations <- ndata[,315:323]

# select only relevant data, exclude 201107 because no questionnaire was fielded
ndata <-  ndata[,c(278:307,309:313)]
# now, make a count of 1 across rows, and store these as numbers.
nperwave <- as.numeric(apply(ndata,2,FUN=function(x) length(which(x=='selected for at least 1 questionnaire and completed at least one'))))
nperwave <- 3217-nperwave
# create a figure with sample sizes [figure as in paper]
#install.packages("ggplot2")
require(ggplot2)
# melt data
#install.packages("reshape")
require(reshape)
nperwavefigure <- melt(nperwave)
# note. 0912 and 1107 are not used
nperwavefigure$wave <- 1:35
samplesizes <- ggplot(nperwavefigure, aes(y=value, x=wave))+
  geom_point()+
  geom_line()+
  ggtitle("Sample sizes December 2008-December 2011 in LISS panel")+
  ylab("sample size")+
  ylim(1500,3000)+
  theme_bw()+
  xlab("waves")
  # now save it
ggsave(samplesizes, file = "D:/SURFdrive/Onderzoek/common metric/paper/sample sizes.png", width = 10, height = 5)

nperwave <- nperwave[nperwave>0]
tablefit <- as.data.frame(fit[,c(7,8,15,20,25)])
fittable <- cbind(tablefit,nperwave)
# write table [as in Appendix A of paper]
write.table(fittable, "D:/SURFdrive/Onderzoek/common metric/paper/model fit.xls", sep='\t',  row.names=F ) 


##########################################################################################
################# PROCESS THE MTMM DATA #################################################
##########################################################################################

# first, import the single mode file 
######################  MTMM model (single group) ####################
resultMTMM <-extractModelParameters("D:/SURFdrive/Onderzoek/common metric/meref basic trust institutions.out", recursive=T)
MTMM0 <- resultMTMM[-2] # deletes R-square from the list!
MTMM2 <- matrix(unlist(MTMM0),nrow=63,byrow=F)
MTMM22 <- as.data.frame(MTMM2[,-c(7,14,21)])

# store the relevant parameters in a vector.
MTMMmethodmeans <- as.numeric(as.character(MTMM22[c(37:39),3]))
#View(MTMMmethodmeans)
MTMMmethodvariance <- as.numeric(as.character(MTMM22[c(52:54),3]))
MTMMmethodmeansse <- as.numeric(as.character(MTMM22[c(37:39),4]))
MTMMmethodmeanstable <- cbind(MTMMmethodmeans,MTMMmethodmeansse,MTMMmethodvariance)

MTMMtraitmeans <- as.numeric(as.character(MTMM22[c(34:36),3]))
MTMMtraitvariance <- as.numeric(as.character(MTMM22[c(50:52),3]))
MTMMtraitmeansse <- as.numeric(as.character(MTMM22[c(34:36),4]))
MTMMtraitmeanstable <- cbind(MTMMtraitmeans,MTMMtraitmeansse,MTMMtraitvariance)

MTMMtraitloadings <- as.numeric(as.character(MTMM22[c(1:9),8]))
MTMMmethodloadings <- as.numeric(as.character(MTMM22[c(10:18),8]))
MTMMvalidity <- MTMMtraitloadings
MTMMreliability <- 1- as.numeric(as.character(MTMM22[c(55:63),8]))
  
MTMMmethodeffects <- MTMMmethodloadings
#MTMMregression <- as.numeric(as.character(MTMM22[c(19:21),3]))
# create MTMM table for paper
#MTMMquality <- sqrt((MTMMtraitloadings*MTMMtraitloadings) * (MTMMvalidity*MTMMvalidity))
MTMMtablecontent <- cbind(MTMMreliability,MTMMvalidity,MTMMmethodeffects) #left out quality now
MTMMtablelabel1 <- c("1) parliament","2) legal system", "3) police","1) parliament","2) legal system", "3) police","1) parliament","2) legal system", 
                     "3) police")
MTMMtablelabel2 <- c("1) 0-10 battery","1) 0-10 battery","1) 0-10 battery","2) 0-5 battery","2) 0-5 battery","2) 0-5 battery"
                     ,"3) 0-10 score","3) 0-10 score","3) 0-10 score")

MTMMtable <- cbind(MTMMtablelabel1,MTMMtablelabel2,MTMMtablecontent)
table(MTMMtable)
#View(MTMMtable)
# write table 
write.table(MTMMtable, "D:/SURFdrive/Onderzoek/common metric/paper/MTMM quality.xls", sep='\t', row.names=F) 
# line above generates table 2 of the paper
write.table(cov(correlations),"D:/SURFdrive/Onderzoek/common metric/paper/covariances.xls", sep='\t', row.names=F)
# line above generates table 1 of the paper

MTMMmeans <- rbind(MTMMtraitmeanstable,MTMMmethodmeanstable)
MTMMmeanstablelabel1 <-c("1) Latent trait mean trust in parliament","2) Latent trait mean trust in legal system","3) Latent trait mean trust in police",
                         "1) Latent method mean trust in parliament (ref)","2) Latent method mean trust in legal system","3) Latent method mean trust in police")
MTMMmeanstable <- cbind(MTMMmeanstablelabel1,MTMMmeans)
write.table(MTMMmeanstable, "D:/SURFdrive/Onderzoek/common metric/paper/MTMM means basic.xls", sep='\t', row.names=F) 
#line above generates table 2 


######################### now import from the multigroup files ################
# extract the means of traits from file 
# and now extract all relevant parameter estimates 
# make sure that all models run and fit
test0 <- results
test22 <- as.matrix(unlist(test0),nrow=126,byrow=T)
test3 <- matrix(unlist(test22),nrow=3636,byrow=F)

# extract means, with their se's 
meanstraits <- test3[c(286:288),]
meanmethodfactor <- test3[c(289:291),]
#View(meanmethodfactor)
meantraitse <- test3[c(412:414),]
meanfactorse <- test3[c(415:417),]
# extract trait loadings (for reliability and validity)
traitloadings <-test3[c(1243:1251),]
methodloadings <-test3[c(1252:1260),]
reliabilities <- test3[c(1297:1305),]

#View(traitloadings)
#View(methodloadings)
# now, take the longitudinal datasets, and substract the cross-sectional estimates from wave 1
# because longitudinal datasets is saved as factors, need to change it again 
# make the wave 1 of same size
MTMMmethod <- as.data.frame(matrix(rep(MTMMmethodmeans,35),nrow=3,ncol=35))
Cmethodmeans <- cbind(as.numeric(unlist(MTMMmethod)) - as.numeric(meanmethodfactor))
#View(Cmethodmeans)

# here, we are not merely interested in method means. But in overall variation in method means
# stole this from http://stackoverflow.com/questions/9379065/how-to-sum-grouped-elements-of-a-vector-in-r
# first make it into absolute number
meanmethodfactor <- as.numeric(unlist(meanmethodfactor))
absmethodmeans <- abs(as.numeric(Cmethodmeans)/2)
# View(absmethodmeans)
# then, apply mean function to it.
methodvariation <- tapply(absmethodmeans, (seq_along(absmethodmeans)-1) %/% 3,mean)
#View(methodvariation)

# traitmeans
test4 <- as.numeric(as.character(unlist(meanstraits)))
Ctraitmeans  <- test4 - MTMMtraitmeans

#traitloadings - validity
test5 <- as.numeric(as.character(unlist(traitloadings)))
Ctraitloadings <- test5 - MTMMtraitloadings

#methodloadings - method effects
test6 <- as.numeric(as.character(unlist(methodloadings)))
Cmethodloadings <- as.data.frame(test6 - MTMMmethodloadings)
#View(test6)

#reliability
test7 <- 1-as.numeric(as.character(unlist(reliabilities)))
Creliability <- test7 - MTMMreliability

#View(MTMMvalidity)
# compute validity coefficient
validity <- test5
reliability <- test7
#test7 <- as.numeric(as.character(unlist(validity)))
# produces change in validity estimates
Cvalidity <- as.data.frame(validity - MTMMvalidity)
#View(Cvalidity)

#test8 <- as.numeric(as.character(unlist(regression)))
#Cregression <- test8 - MTMMregression 

################ now combine item into two objects for plottting
# 9-item for loadings
# 3 items for means + regressioncoefficients 
#View(validity)
loadingscombined <- as.data.frame(cbind(reliability,Creliability,validity,Cvalidity)) #1.
meanmethodfactor <- as.numeric(as.character(unlist(meanmethodfactor))) # make it numeric as well
Cmethodmeans <- as.numeric(Cmethodmeans)
meansbcombined <- as.data.frame(cbind(Ctraitmeans,meanmethodfactor,Cmethodmeans)) #2.
#View(meansbcombined)

meansbcombined$methodvariation <- rep(methodvariation)
#View(meansbcombined$methodvariation)
meansbcombined$MTMMmeans <- rep(MTMMmethodmeans,c(35))

#class(loadingscombined)
# now add some handy columns for creating the plots
meansbcombined$latent <- rep(1:3)
loadingscombined$latent <- rep(1:9)
meansbcombined$wave <-   rep(1:35,c(3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3))
loadingscombined$wave <- rep(1:35,c(9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9))
# now, add one variable that reflects the mean in the change in quality (no longer used)
#loadingsmean <- tapply(loadingscombined$Cquality, (seq_along(loadingscombined$Cquality)-1) %/% 9, mean)
#loadingscombined$means <- rep(loadingsmean,c(9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9))

# add up differences in trait and method means
# for this, need to ceate a product matrix - 3 x3.

######################################################################
# I want moving averages to make the plot look nicer. Here is a function I stole 
# http://druedin.com/2012/08/11/moving-averages-in-r/

mav <- function(x,n=3){filter(x,rep(1/n,n), sides=2)}
# ah crap. I need to change the order of the matrix, so that it is ordered on latent.
# use the order variable to order on latent variable
meansbcombined <- meansbcombined[order(meansbcombined$latent),] 
#now, add this moving average to the data frame
meansbcombined$mavtraitmeans <- as.numeric(mav(meansbcombined$Ctraitmeans))
# impose a 0 for the first 2 waves (they get an NA in the mav-function)
meansbcombined$mavtraitmeans[meansbcombined$wave <3] <- 0

# now do the same for the method means
meansbcombined <- meansbcombined[order(meansbcombined$latent),] 
meansbcombined$mavmethodmeans <- as.numeric(mav(meansbcombined$meanmethodfactor))
meansbcombined$mavmethodmeans[meansbcombined$wave <3] <- 0

#now do the same for method variation 
meansbcombined <- meansbcombined[order(meansbcombined$latent),] 
meansbcombined$mavmethodvariation <- as.numeric(mav(meansbcombined$methodvariation))
meansbcombined$mavmethodvariation[meansbcombined$wave <3] <- 0
# create a total bias coefficient
meansbcombined$totalbias <- meansbcombined$Ctraitmeans + meansbcombined$meanmethodfactor

# later plot these in 9 interaction-tables
# Ctraitmeans *
# meanmethodfactor
# totalbias

# or plot these in 3 interaction tables
# Ctraitmeans 
# methodvariation
# totalbias

# now do the same for the quality coefficient
loadingscombined <- loadingscombined[order(loadingscombined$latent),] 
#loadingscombined$mavquality[loadingscombined$wave<4]  <- as.numeric(loadingscombined$quality[loadingscombined$wave<4])
#loadingscombined$mavquality[loadingscombined$wave>3]  <- as.numeric(mav(loadingscombined$quality[loadingscombined$wave>3]))
#loadingscombined$mavCquality[loadingscombined$wave<4] <- as.numeric(loadingscombined$Cquality[loadingscombined$wave<4])
#loadingscombined$mavCquality[loadingscombined$wave>3] <- as.numeric(mav(loadingscombined$Cquality[loadingscombined$wave>3]))
loadingscombined$mavreliability[loadingscombined$wave<4]    <- as.numeric(loadingscombined$reliability[loadingscombined$wave<4])
loadingscombined$mavreliability[loadingscombined$wave>3]    <- as.numeric(mav(loadingscombined$reliability[loadingscombined$wave>3]))
loadingscombined$mavvalidity[loadingscombined$wave<4] <- as.numeric(loadingscombined$validity[loadingscombined$wave<4])
loadingscombined$mavvalidity[loadingscombined$wave>3] <- as.numeric(mav(loadingscombined$validity[loadingscombined$wave>3]))


loadingscombined$question <- factor(loadingscombined$latent, 
                        levels=c("1","2","3","4","5","6","7","8","9"), 
                        labels=c("parliament, 0-10 battery",
                                 "legal system, 0-10 battery",
                                 "police, 0-10 battery",
                                 "parliament, 0-5  battery",
                                 "legal system, 0-5  battery",
                                 "police, 0-5  battery",
                                 "parliament, 0-10 score",
                                 "legal system, 0-10 score",
                                 "police, 0-10 score"))
meansbcombined$question <- factor(meansbcombined$latent, 
                                    levels=c("1","2","3","4","5","6","7","8","9"), 
                                    labels=c("parliament, 0-10 battery",
                                             "legal system, 0-10 battery",
                                             "police, 0-10 battery",
                                             "parliament, 0-5  battery",
                                             "legal system, 0-5  battery",
                                             "police, 0-5  battery",
                                             "parliament, 0-10 score",
                                             "legal system, 0-10 score",
                                             "police, 0-10 score"))

######################################################################
# make a plot
#install.packages("ggplot2")
require(ggplot2)
library(ggplot2)


#meantraits <- # not in paper, later combied with method means
 plot1 <-
   ggplot(meansbcombined, aes(y=mavtraitmeans, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ylab("difference in latent trait means")+
  xlab("waves")+
  theme_bw()+
   scale_colour_discrete(name="Latent Trait \n Mean differences",
                       breaks=c("parliament, 0-10 battery","legal system, 0-10 battery", "police, 0-10 battery"),
                       labels=c("parliament", "legal system", "police"))

#methodtraits <- # not in paper, later combined with trait means
plot2 <-
  ggplot(meansbcombined, aes(y=Cmethodmeans, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ylab("difference in latent method means")+
  xlab("waves")+
  theme_bw()+
  scale_colour_discrete(name="Relative Method \n Mean differences",
                        breaks=c("parliament, 0-10 battery","legal system, 0-10 battery", "police, 0-10 battery"),
                        labels=c("0-10 battery", "0-5 battery", "0-10 score"))

#methodvariation <- # not in paper

ggplot(meansbcombined, aes(y=methodvariation, x=wave))+
  geom_point()+
  geom_line()+
  ggtitle("means of Latent trait factors over time")+
  ylab("average difference in method variation")+
  xlab("waves")+
  labs(colour="Variable")

# traitloadings <- #not in paper, later combined with validity
ggplot(loadingscombined, aes(y=reliability, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ggtitle("Value of reliabilities over time")+
  ylab("reliability coefficient")+
  xlab("waves")+
  #  ylim(0.81,1.05)+
  labs(colour="Variable")

# validityloadings <- #not in paper, later combined with reliability
ggplot(loadingscombined, aes(y=validity, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ggtitle("means of method loadings")+
  ylab("validity coefficient")+
  xlab("waves")+
 # ylim(0.8,1.0)+
  labs(colour="Variable")

# quality is no longer focus of paper

# changed this not to use moving averages in this table
#quality <- # no longer used
#ggplot(loadingscombined, aes(y=quality, x=wave, group=question,colour=question))+
  #geom_point()+
  #geom_line()+
  #ggtitle("Value of quality coefficients over time")+
  #ylab("quality coefficient")+
  #xlab("waves")+
  #ylim(0.75,max(loadingscombined$mavquality))+
  #labs(colour="Variable")

#Cquality <- # no longer used
#ggplot(loadingscombined, aes(y=mavCquality, x=wave, group=question,colour=question))+
#  geom_point()+
 # geom_line()+
#  ggtitle("Value of quality loadings over time")+
 # ylab("difference in quality coefficient")+
#  xlab("waves")+
 # ylim(0.75,max(loadingscombined$mavCquality))+
  #labs(colour="Variable")


# lets combine quality validity reliability
# not use the MAV variables


combined <- loadingscombined[,c(6,9,1,3,7,8)]
#
require(reshape)
combined <- melt(combined, id = c("question","wave"))
combined$variable <- factor(combined$variable, levels= c("reliability","validity", "mavreliability","mavvalidity"), 
                            labels =c("reliability", "validity","mavreliability","mavvalidity"))
#View(combined)
# below is ok
combinedloadingsfigure <-
ggplot(combined[c(1:630),], aes(y=value,x=wave, colour=question,shape=question))+
  geom_point()+
  geom_line()+
  ggtitle("Reliability and validity  loadings over time")+
  ylab("size of coefficient")+
  xlab("waves")+
  theme_bw()+
  facet_wrap( ~ variable)
  #ylim(0.75,max(loadingscombined$mavvalidity))+
 # theme(legend.position=c(1.0,0.3))
 # labs(shape="question")

#combine the two earlier plots
#install.packages("ggpubr")
require(ggpubr)
require(gridExtra)
meansplot <- grid.arrange(plot1,plot2, 
                      ncol=1,nrow=2)
ggsave(meansplot, file = "D:/SURFdrive/Onderzoek/common metric/paper/combined means.png", width = 10, height = 6)
meansplot

# and now do the same for the means
# select mavtraitmeans, mavmethodmeans, latent wave
#combinedmeans <- meansbcombined[,c(12,7,8,3)]
#View(meansbcombined)
#View(combinedmeans)
#combinedmeans <- melt(combinedmeans, id = c("question","wave"))
#combinedmeans$variable <- rep(1:2,each=105)
#combinedmeans$variable <- factor(combinedmeans$variable, levels= c("1","2"), 
 #                           labels =c("Latent trait mean","Latent method mean"))
#
#
#combinedmeansfigure 
#  ggplot(combinedmeans, aes(y=value,x=wave,group=question,colour=question))+
#  geom_point()+
#  geom_line()+
#  ggtitle("Difference in latent trait and latent method means over time")+
#  ylab("size of coefficient")+
#  xlab("waves")+
#  theme_bw()
#  facet_grid(. ~ variable, scales="free")+
#  labs(colour="Latent Mean")

  
################################ interactions between errors ##############

# THE PART BELOW IS NO LONGER USED IN PAPER. 


# now plot these in 9 interaction-tables
# Ctraitmeans *
# meanmethodfactor
# totalbias

# or plot these in 3 interaction tables
# Ctraitmeans 
# methodvariation
# totalbias

# plot interaction of mavtraitmeans[mavtraitmeans==1] and mavmethodmeans[mavtraitmeans==3]
# first create data like this.
#attach(meansbcombined)
#require(ggplot2)
trait1method1 <- c(meansbcombined$Ctraitmeans[latent==1],meansbcombined$meanmethodfactor[latent==1])
trait1method2 <- c(meansbcombined$Ctraitmeans[latent==1],meansbcombined$meanmethodfactor[latent==2])
trait1method3 <- c(meansbcombined$Ctraitmeans[latent==1],meansbcombined$meanmethodfactor[latent==3])
trait2method1 <- c(meansbcombined$Ctraitmeans[latent==2],meansbcombined$meanmethodfactor[latent==1])
trait2method2 <- c(meansbcombined$Ctraitmeans[latent==2],meansbcombined$meanmethodfactor[latent==2])
trait2method3 <- c(meansbcombined$Ctraitmeans[latent==2],meansbcombined$meanmethodfactor[latent==3])
trait3method1 <- c(meansbcombined$Ctraitmeans[latent==3],meansbcombined$meanmethodfactor[latent==1])
trait3method2 <- c(meansbcombined$Ctraitmeans[latent==3],meansbcombined$meanmethodfactor[latent==2])
trait3method3 <- c(meansbcombined$Ctraitmeans[latent==3],meansbcombined$meanmethodfactor[latent==3])
interactiondata <- as.data.frame(cbind(trait1method1,trait1method2,trait1method3,trait2method1,trait2method2,
                                       trait2method3,trait3method1,trait3method2,trait3method3))
interactiondata$component  <- c(1,1,1,1,1,1,1,1,1,1,
                               1,1,1,1,1,1,1,1,1,1,
                               1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                               2,2,2,2,2,2,2,2,2,2,
                               2,2,2,2,2,2,2,2,2,2,
                               2,2,2,2,2,2,2,2,2,2,2,2,2,2,2)
#install.packages("reshape")
require(reshape)
interactdata <- melt(interactiondata, id="component")
interactdata$time <- rep(1:35)
# stacked bar chart with positive and negative values? Here is neat trick:
# http://stackoverflow.com/questions/13734368/ggplot2-and-a-stacked-bar-chart-with-negative-values
dat1 <- subset(interactdata,value >= 0)
dat2 <- subset(interactdata,value < 0)
# create total bias indicator
dat3 <- as.data.frame(interactdata$value[interactdata$component==1]+interactdata$value[interactdata$component==2])
dat3$time <- rep(1:35)
dat3$variable <- rep(1:9, c(35,35,35,35,35,35,35,35,35))
names(dat3)[1] <- "value"
dat3$variable <- factor(dat3$variable, levels=c("1","2","3","4","5","6","7","8","9"), labels= c("trait1method1","trait1method2","trait1method3",
                          "trait2method1","trait2method2","trait2method3","trait3method1","trait3method2","trait3method3"))
# create poistive and negative numbers
dat4 <- subset(dat3,value >= 0)
dat5 <- subset(dat3,value < 0)

# finally, to see the trade-off in nonresponse and measurement error
#stackedplot <- 
# i want to change some things maybe. plot the total bias? but idea is right.
interactionfigure1 <-
ggplot() + 
  geom_bar(data=dat1, aes(y=value,x=time,  fill=factor(component)), stat="identity") +
  geom_bar(data=dat2, aes(y=value,x=time,  fill=factor(component)), stat="identity") +
  geom_point(data=dat4, aes(y=value,x=time,stat="identity"))+
  geom_point(data=dat5, aes(y=value,x=time,stat="identity"))+
  guides(fill=guide_legend("Trait or method bias"),shape=guide_legend("Trait/method")) +
  ggtitle("Relative bias in means")+
  ylab(expression(paste("relative bias in mean")))+
  xlab("waves")+
  facet_wrap(~ variable ,scales="free")+
  scale_fill_discrete(labels=c("nonresponse","measurement"))
 # labs(colour="Bias in means")

interactiondata2 <- as.data.frame(cbind(meansbcombined$Ctraitmeans,meansbcombined$methodvariation,
                          meansbcombined$question,meansbcombined$wave))
interactiondata2$totalbias <- interactiondata2$V1 + interactiondata2$V2
names(interactiondata2) <- c("relative bias in trait means","Average relative method bias","Latent_Trait","time","total bias")
interactiondata2$Latent_Trait <- factor(interactiondata2$Latent_Trait, 
                            levels=c("1","2","3"), 
                            labels= c("Trust in parliament","Trust in legal system","Trust in police"))
#View(interactiondata2)
cormatrix <- cor(interactiondata2[,c(1,2,5,4)])
write.table(cormatrix,  file = "D:/SURFdrive/Onderzoek/common metric/paper/cormatrix interactions.xls")
                                                                                               
interactdata2 <- melt(interactiondata2, id=c("Latent_Trait","time"))
interactdata2$Bias_component <- interactdata2$variable
                                
# do the +- thing for bars
dat6 <- subset(interactdata2,value >= 0)
dat7 <- subset(interactdata2,value < 0)
#View(dat6)


#create figure
#?ggplot
#labs2 <- list(expression(C[A]), expression(C[B]),expression(C[C]))

#interactionfigure2 <-
#ggplot() + 
#  geom_jitter(data=dat6, aes(y=value,x=time, colour=Bias_component, shape=Bias_component), stat="identity") +
#  geom_jitter(data=dat7, aes(y=value,x=time, colour=Bias_component, shape=Bias_component), stat="identity") +
#  ggtitle("Relative bias in means")+
#  ylab(expression(paste("relative bias in mean")))+
#  xlab("waves")+
#  facet_wrap(~ Latent_Trait)


interactionfigure3 <-
ggplot() + 
  geom_point(data=interactdata2, aes(y=value,x=time, colour=Bias_component, shape=Bias_component), stat="identity") +
  ggtitle("Relative bias in means")+
  ylab(expression(paste("relative bias in mean")))+
  xlab("waves")+
  facet_wrap(~ Latent_Trait)



####################################################################
 

# save the plots
ggsave(combinedloadingsfigure, file = "D:/SURFdrive/Onderzoek/common metric/paper/combined loadings.png", width = 10, height = 5)
# THE LINE ABOVE GENERATES FIGURE 4
ggsave(meansplot, file = "D:/SURFdrive/Onderzoek/common metric/paper/combined means.png", width = 10, height = 5)
# THE LINE ABOVE GENERATES FIGURE 5
#ggsave(interactionfigure1, file = "D:/SURFdrive/Onderzoek/common metric/paper/interaction bias means 1.png", width = 10, height = 5)
#ggsave(interactionfigure2, file = "D:/SURFdrive/Onderzoek/common metric/paper/interaction bias means 2.png", width = 10, height = 5)
#ggsave(interactionfigure3, file = "D:/SURFdrive/Onderzoek/common metric/paper/interaction bias means 3.png", width = 10, height = 5)

#save ethe workspace
save.image("D:/SURFdrive/Onderzoek/common metric/paper/workspace.Rdata")
